//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.12

import wesual.Ui 1.0

import wesual.Ui.Private 1.0

UiPushButtonBase {
    id : uiPushButton

    implicitHeight   : button.implicitHeight
    implicitWidth    : button.implicitWidth
    activeFocusOnTab : true

    Loader {
        id : button

        sourceComponent : uiPushButton.style === Ui.PrimaryPushButtonStyle ?
                              primaryStyle : secondaryStyle
    }

    Component {
        id : primaryStyle

        Rectangle {
            id : background

            color          : UiColors.getColor(UiColors.ButtonNormalBlue)
            implicitWidth  : Math.max(80, label.implicitWidth + 28)
            implicitHeight : 30

            border {
                width : 0
                color : "transparent"
            }

            states : [
                State {
                    name : "disabled"
                    when : !uiPushButton.enabled

                    PropertyChanges {
                        target : background
                        color  : UiColors.getColor(UiColors.DisabledLightGrey13)
                    }
                    PropertyChanges {
                        target : label
                        color  : UiColors.getColor(UiColors.White)
                    }
                },
                State {
                    name : "pressed"
                    when : uiPushButton.pressed

                    PropertyChanges {
                        target  : background
                        color   : UiColors.getColor(UiColors.ButtonPressBlue)
                        visible : true
                    }
                },
                State {
                    name : "focus"
                    when : uiPushButton.activeFocus

                    PropertyChanges {
                        target : background
                        border {
                            width : 2
                            color : UiColors.getColor(
                                        UiColors.ButtonPressBlue, .4)
                        }
                    }
                },
                State {
                    name : "hovered"
                    when : uiPushButton.hovered

                    PropertyChanges {
                        target  : background
                        color   : UiColors.getColor(UiColors.ButtonHoverBlue)
                        visible : true
                    }
                }
            ]

            Text {
                id : label

                color : UiColors.getColor(UiColors.White)
                font  : UiFonts.getFont(UiFonts.Regular, 14)
                text  : uiPushButton.text

                anchors.centerIn : parent
            }
        }
    }

    Component {
        id : secondaryStyle

        Item {
            implicitWidth  : Math.max(80, label.implicitWidth + 28)
            implicitHeight : 30

            states : [
                State {
                    name : "disabled"
                    when : !uiPushButton.enabled

                    PropertyChanges {
                        target : label
                        color  : UiColors.getColor(UiColors.MediumLightGrey27)
                    }
                },
                State {
                    name : "highlight"
                    when : uiPushButton.pressed

                    PropertyChanges {
                        target : label
                        color  : UiColors.getColor(UiColors.LinkPressBlue)
                    }
                    PropertyChanges {
                        target  : line
                        opacity : 1
                        color   : UiColors.getColor(UiColors.LinkPressBlue)
                    }
                },
                State {
                    name : "hovered"
                    when : uiPushButton.hovered || uiPushButton.activeFocus

                    PropertyChanges {
                        target  : line
                        opacity : 1
                    }
                }
            ]

            UiFocusRect {
                anchors.fill : parent
                target       : uiPushButton
            }

            Text {
                id : label

                font     : UiFonts.getFont(UiFonts.Regular, 14)
                wrapMode : Text.NoWrap
                elide    : Text.ElideRight
                color    : UiColors.getColor(UiColors.ButtonPressBlue)
                text     : uiPushButton.text
                anchors {
                    horizontalCenter : parent.horizontalCenter
                    verticalCenter   : parent.verticalCenter
                }
            }

            Rectangle {
                id : line

                anchors {
                    top       : label.baseline
                    topMargin : 4
                    left      : label.left
                    right     : label.right
                }
                height  : 2
                color   : UiColors.getColor(UiColors.ButtonPressBlue)
                opacity : 0
            }
        }
    }
}

